#include "pch.h"
#include "CfgParse.hpp"
#include "Common.hpp"
#include "Misc.hpp"
#include "Lng.hpp"

CLng::CLng() {
	m_iNumberOfLines = 0;
}

CLng::~CLng() {
	FreeLinesMemory();
}

void CLng::FreeLinesMemory() {
	while (!m_vLines.empty()) {
		LPTSTR	szLine = m_vLines.back();
		m_vLines.pop_back();
		delete [] szLine;
	}
	m_iNumberOfLines = 0;
}

bool CLng::Read(LPCTSTR szLngFileName) {
	basic_string<TCHAR>	sLine;
	basic_string<TCHAR>	sValue;

	bool		fWaitingSubline, fParserError;
	int		iLen;

	LPTSTR		szLine;
    
	FreeLinesMemory();
    
	// connect the parser to the file
	CCfgParser	LngParser( szLngFileName );
	if (LngParser.Failed())
		return (false);


	fWaitingSubline  = false;
	fParserError     = false;
	m_iNumberOfLines = 0;
	while (!LngParser.Eof()) {
		// read line
		LngParser.ReadLine();
		// check errors
		if (LngParser.Failed()) {
			if (!LngParser.Eof())
			fParserError = true;
			break;
		}
		// skip empty lines
		if (LngParser.Count() == 0)
			continue;
		// check syntax
		if (LngParser.Count() > 2 || LngParser[0][0] != _T('"') ||
		    (LngParser.Count() == 2 && lstrcmp( LngParser[1], _T("\\") ) != 0))
		{
			fParserError = 1;
			break;
		}
		iLen = lstrlen( LngParser[0] ) - 2;
		sValue = LngParser[0];
		sLine += sValue.substr( 1, iLen );
		if (LngParser.Count() == 2) {
			fWaitingSubline = true;
			sLine += _T("\r");
		}
		else {
			fWaitingSubline = false;
			szLine = new TCHAR[sLine.length() + 1];
			lstrcpy( szLine, sLine.c_str() );
			sLine = _T("");
			ConvertSoftCR( szLine );
			m_vLines.push_back( szLine );
			m_iNumberOfLines++;
		}
	}
	if (fParserError || fWaitingSubline) {
		FreeLinesMemory();
		return (false);
	}
	if (m_iNumberOfLines == 0)
		return (false);
	return (true);
}

LPTSTR CLng::operator [](int i) {
	assert(i >= 0 && i < m_iNumberOfLines);
	return (m_vLines[i]);
}
